IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Finan_Creditos_Saldo]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Finan_Creditos_Saldo] 
END
GO

CREATE PROCEDURE [dbo].[CP_Finan_Creditos_Saldo]
AS

DECLARE @Tipo_Amortizacion CHAR(1)
       ,@Meses_Cant SMALLINT
	   ,@Tasa_EM DECIMAL(14,9)
	   ,@Imp_Capital DECIMAL(16,2)
	   ,@Fecha_Desde DATETIME
	   ,@Id_Cta_Banco INT

CREATE TABLE #Result (
	    Fecha			DATETIME
      , NroCuota		SMALLINT 
      , SaldoInicial	DECIMAL(16,2)
	  , ValorCuota		DECIMAL(16,2)
	  , Intereses		DECIMAL(16,2)
	  , Amortizacion	DECIMAL(16,2) 
	  , AmortACum		DECIMAL(16,2) 
	  , SaldoFinal		DECIMAL(16,2)
	  , FechaPago       DATETIME
	  , Id_Cliente			INT
	  , Razon_Social		VARCHAR(100)
	  , Id_Cliente_Externo	VARCHAR(14)
	  , Id_Cta_Banco		SMALLINT
	  , Cuenta_Nro			VARCHAR(50)
	  , Cuenta_Descrip		VARCHAR(100)
	  )
CREATE TABLE #Resultado (
	    Fecha			DATETIME
      , NroCuota		SMALLINT 
      , SaldoInicial	DECIMAL(16,2)
	  , ValorCuota		DECIMAL(16,2)
	  , Intereses		DECIMAL(16,2)
	  , Amortizacion	DECIMAL(16,2) 
	  , AmortACum		DECIMAL(16,2) 
	  , SaldoFinal		DECIMAL(16,2)
	  , FechaPago       DATETIME
	  , Id_Cliente			INT
	  , Razon_Social		VARCHAR(100)
	  , Id_Cliente_Externo	VARCHAR(14)
	  , Id_Cta_Banco		SMALLINT
	  , Cuenta_Nro			VARCHAR(50)
	  , Cuenta_Descrip		VARCHAR(100)
	  )


 DECLARE CUR_PRESTAMOS CURSOR FOR
	  SELECT Tipo_Amortizacion,Meses_Cant,Tasa_EM,Imp_Capital,Fecha_Desde,Id_Cta_Banco FROM Bancos_Ctas WHERE ACTIVO = 1 AND Id_Bco_Cta_Tipo = 6

 OPEN CUR_PRESTAMOS
 FETCH NEXT FROM CUR_PRESTAMOS INTO  @Tipo_Amortizacion,@Meses_Cant,@Tasa_EM,@Imp_Capital,@Fecha_Desde,@Id_Cta_Banco 
 WHILE @@FETCH_STATUS = 0
	BEGIN
	  INSERT INTO #Result 
         EXEC CP_FINAN_CREDITOS @Tipo_Amortizacion,@Meses_Cant,@Tasa_EM,@Imp_Capital,@Fecha_Desde,0,@Id_Cta_Banco 

      IF isnull((SELECT COUNT(*) FROM #Result WHERE  FechaPago IS NOT NULL ),0) > 0
           INSERT INTO #RESULTADO 
              SELECT TOP 1 * FROM #Result WHERE  FechaPago IS NOT NULL ORDER BY  NroCuota DESC
        ELSE
           INSERT INTO #RESULTADO 
              SELECT TOP 1 * FROM #Result WHERE NroCuota = 0

      DELETE #Result 
		 		  
   FETCH NEXT FROM CUR_PRESTAMOS INTO  @Tipo_Amortizacion,@Meses_Cant,@Tasa_EM,@Imp_Capital,@Fecha_Desde,@Id_Cta_Banco 
 END  
 CLOSE CUR_PRESTAMOS
 DEALLOCATE CUR_PRESTAMOS 
 
 SELECT  * FROM #Resultado

 Drop Table #Result 
 
 Drop Table #Resultado 


 -- exec [dbo].[CP_Finan_Creditos_Saldo]




